﻿#include "precompiled.h"
#include "common.h"
#include "AppWindow.h"

// Forward declarations
LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);

// Constants //////////////////////////////////////////////////////////////////////////
const wchar_t kWindowClass[] = L"RealtimeCameraSim";		// The name of the application
const wchar_t kTitle[] = L"Realtime Camera Simulation";		// The text that appears in the title bar

const int kMinimizedSize = 8;

// Class functions //////////////////////////////////////////////////////////////////////////
namespace RTCam {

AppWindow::AppWindow() :
	m_initialized(false),
	m_instanceHandle(nullptr),
	m_windowHandle(nullptr),
	m_clientSize(0, 0)
{
}

AppWindow::~AppWindow() {
}

HRESULT AppWindow::InitWindow(_In_ const HINSTANCE hInstance, const int nCmdShow)
{
	ASSERT(m_initialized == false);

	// Register class
	WNDCLASSEX wcex;
	wcex.cbSize = sizeof(WNDCLASSEX);
	wcex.style          = CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc    = WndProc;
	wcex.cbClsExtra     = 0;
	wcex.cbWndExtra     = 0;
	wcex.hInstance      = hInstance;
	wcex.hIcon          = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_APPLICATION));
	wcex.hCursor        = LoadCursor(nullptr, IDC_ARROW);
	wcex.hbrBackground  = (HBRUSH)(COLOR_WINDOW + 1);
	wcex.lpszMenuName   = nullptr;
	wcex.lpszClassName  = kWindowClass;
	wcex.hIconSm        = LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_APPLICATION));
	
	if (!RegisterClassEx(&wcex)) {
		ShowMessageBox(L"Call to RegisterClassEx failed!", kWindowClass);
		return E_FAIL;
	}

	// Calculate the size of the client area
	RECT clientSize = {0, 0, kInitialWidth, kInitialHeight};    // set the size, but not the position
	AdjustWindowRect(&clientSize, WS_OVERLAPPEDWINDOW, FALSE);    // adjust the size
	int clientWidth = clientSize.right - clientSize.left;
	int clientHeight = clientSize.bottom - clientSize.top;

	// Create the window
	m_instanceHandle = hInstance;
	m_windowHandle = CreateWindow(
		kWindowClass,
		kTitle,
		WS_OVERLAPPEDWINDOW,			// Window type
		CW_USEDEFAULT, CW_USEDEFAULT,	// Initial (x, y) position
		clientWidth, clientHeight,	// Initial size
		nullptr,						// The parent of this window
		nullptr,						// The menu bar (if any)
		hInstance,						// Parameter from WinMain
		nullptr							// Unused by this app
	);

	if (!m_windowHandle) {
		ShowMessageBox(L"Call to CreateWindow failed!", kWindowClass);
		return E_FAIL;
	}

	OnResize();

	// Display the window
	ShowWindow(m_windowHandle, nCmdShow);
	UpdateWindow(m_windowHandle);

	m_initialized = true;

	return S_OK;
}

void AppWindow::OnResize()
{
	// Get client area dimensions
	RECT rect;
	GetClientRect(m_windowHandle, &rect);
	m_clientSize.x = rect.right - rect.left;
	m_clientSize.y = rect.bottom - rect.top;
}

DirectX::XMINT2 RTCam::AppWindow::GetClientSize()
{
	if(m_clientSize.x == 0 || m_clientSize.y == 0) {
		// This happens when the window is minimized.
		DebugPrint("The window was resized with a value of 0, using %d as a reasonable minimum value for the client size.\n", kMinimizedSize);
		m_clientSize.x = kMinimizedSize;
		m_clientSize.y = kMinimizedSize;
	}
	return m_clientSize;
}

} // end namespace